<Query Kind="Program">
  <Namespace>System.Runtime.InteropServices</Namespace>
</Query>

static void Main() 
{ 
	Watch (TempDirectory, "*.txt", true); 
}

static void Watch (string path, string filter, bool includeSubDirs)
{
	using (var watcher = new FileSystemWatcher (path, filter))
	{
		watcher.Created += FileCreatedChangedDeleted;
		watcher.Changed += FileCreatedChangedDeleted;
		watcher.Deleted += FileCreatedChangedDeleted;
		watcher.Renamed += FileRenamed;
		watcher.Error += FileError;

		watcher.IncludeSubdirectories = includeSubDirs;
		watcher.EnableRaisingEvents = true;
		
		Console.WriteLine ("Nasłuchiwanie zdarzeń - zatrzymaj zapytanie, aby zakończyć.");
		Console.ReadLine();
	}
	// Usunięcie FileSystemWatcher zatrzymuje dalsze zgłaszanie zdarzeń.
}

static void FileCreatedChangedDeleted (object o, FileSystemEventArgs e)
	=> Console.WriteLine ("Plik {0} został {1}", e.FullPath, e.ChangeType);

static void FileRenamed (object o, RenamedEventArgs e)
	=> Console.WriteLine ("Zmiana nazwy: {0}->{1}", e.OldFullPath, e.FullPath);

static void FileError (object o, ErrorEventArgs e)
	=> Console.WriteLine ("Błąd: " + e.GetException().Message);
	
static string TempDirectory
{
	get => RuntimeInformation.IsOSPlatform (OSPlatform.Windows) ?
            @"C:\Temp" : "/tmp";  
}